/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package data.structures.classification;

public class Operation {
    public final static Operation ACCES_TITRE = new Operation(0);
    public final static Operation ACCES_DESC = new Operation(1);
    public final static Operation GENERALISATION = new Operation(2);
    public final static Operation CATEGORISATION = new Operation(3);
    public final static Operation CHAMP_SEMANTIQUE = new Operation(4);
    public final static Operation SPECIALISATION = new Operation(5);

    private int id = 0;

    private Operation(int id){
        this.id = id;
    }
    
    @Override
    public boolean equals(Object o){
        if(!(o instanceof Operation)) return false;
        return ((Operation)o).id == id;
    }
}
